package io.k8s.api.core.v1


/** Adapts a Secret into a volume.

The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling. */
final case class SecretVolumeSource(
  defaultMode : Option[Int] = None,
  items : Option[Seq[io.k8s.api.core.v1.KeyToPath]] = None,
  optional : Option[Boolean] = None,
  secretName : Option[String] = None
) {
  def withDefaultMode(value: Int) : SecretVolumeSource = copy(defaultMode = Some(value))
  def withItems(value: Seq[io.k8s.api.core.v1.KeyToPath]) : SecretVolumeSource = copy(items = Some(value))
  def addItems(newValues: io.k8s.api.core.v1.KeyToPath*) : SecretVolumeSource = copy(items = Some(items.fold(newValues)(_ ++ newValues)))

  def withOptional(value: Boolean) : SecretVolumeSource = copy(optional = Some(value))
  def withSecretName(value: String) : SecretVolumeSource = copy(secretName = Some(value))
}

