package io.k8s.api.core.v1


/** Adapts a secret into a projected volume.

The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode. */
final case class SecretProjection(
  items : Option[Seq[io.k8s.api.core.v1.KeyToPath]] = None,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {
  def withItems(value: Seq[io.k8s.api.core.v1.KeyToPath]) : SecretProjection = copy(items = Some(value))
  def addItems(newValues: io.k8s.api.core.v1.KeyToPath*) : SecretProjection = copy(items = Some(items.fold(newValues)(_ ++ newValues)))

  def withName(value: String) : SecretProjection = copy(name = Some(value))
  def withOptional(value: Boolean) : SecretProjection = copy(optional = Some(value))
}

