package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** SecretList is a list of Secret. */
final case class SecretList(
  items : Seq[io.k8s.api.core.v1.Secret],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "SecretList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Secret]) : SecretList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Secret*) : SecretList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : SecretList = copy(metadata = Some(value))
}

