package io.k8s.api.core.v1


/** SecretKeySelector selects a key of a Secret. */
final case class SecretKeySelector(
  key : String,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {
  def withKey(value: String) : SecretKeySelector = copy(key = value)
  def withName(value: String) : SecretKeySelector = copy(name = Some(value))
  def withOptional(value: Boolean) : SecretKeySelector = copy(optional = Some(value))
}

