package io.k8s.api.core.v1


/** SecretEnvSource selects a Secret to populate the environment variables with.

The contents of the target Secret's Data field will represent the key-value pairs as environment variables. */
final case class SecretEnvSource(
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {
  def withName(value: String) : SecretEnvSource = copy(name = Some(value))
  def withOptional(value: Boolean) : SecretEnvSource = copy(optional = Some(value))
}

