package io.k8s.api.core.v1


/** SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set. */
final case class SeccompProfile(
  localhostProfile : Option[String] = None,
  `type` : String
) {
  def withLocalhostProfile(value: String) : SeccompProfile = copy(localhostProfile = Some(value))
  def withType(value: String) : SeccompProfile = copy(`type` = value)
}

