package io.k8s.api.core.v1


/** A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements. */
final case class ScopeSelector(
  matchExpressions : Option[Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]] = None
) {
  def withMatchExpressions(value: Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]) : ScopeSelector = copy(matchExpressions = Some(value))
  def addMatchExpressions(newValues: io.k8s.api.core.v1.ScopedResourceSelectorRequirement*) : ScopeSelector = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))

}

