package io.k8s.api.core.v1


/** ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume */
final case class ScaleIOPersistentVolumeSource(
  system : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : io.k8s.api.core.v1.SecretReference,
  storagePool : Option[String] = None,
  gateway : String,
  protectionDomain : Option[String] = None,
  volumeName : Option[String] = None,
  sslEnabled : Option[Boolean] = None,
  storageMode : Option[String] = None
) {
  def withSystem(value: String) : ScaleIOPersistentVolumeSource = copy(system = value)
  def withReadOnly(value: Boolean) : ScaleIOPersistentVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : ScaleIOPersistentVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : ScaleIOPersistentVolumeSource = copy(secretRef = value)
  def withStoragePool(value: String) : ScaleIOPersistentVolumeSource = copy(storagePool = Some(value))
  def withGateway(value: String) : ScaleIOPersistentVolumeSource = copy(gateway = value)
  def withProtectionDomain(value: String) : ScaleIOPersistentVolumeSource = copy(protectionDomain = Some(value))
  def withVolumeName(value: String) : ScaleIOPersistentVolumeSource = copy(volumeName = Some(value))
  def withSslEnabled(value: Boolean) : ScaleIOPersistentVolumeSource = copy(sslEnabled = Some(value))
  def withStorageMode(value: String) : ScaleIOPersistentVolumeSource = copy(storageMode = Some(value))
}

