package io.k8s.api.core.v1


/** ResourceRequirements describes the compute resource requirements. */
final case class ResourceRequirements(
  limits : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  requests : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {
  def withLimits(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceRequirements = copy(limits = Some(value))
  def addLimits(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceRequirements = copy(limits = Some(limits.fold(newValues.toMap)(_ ++ newValues)))

  def withRequests(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceRequirements = copy(requests = Some(value))
  def addRequests(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceRequirements = copy(requests = Some(requests.fold(newValues.toMap)(_ ++ newValues)))

}

