package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ResourceQuota sets aggregate quota restrictions enforced per namespace */
final case class ResourceQuota(
  status : Option[io.k8s.api.core.v1.ResourceQuotaStatus] = None,
  spec : Option[io.k8s.api.core.v1.ResourceQuotaSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ResourceQuota", "v1")

  def withStatus(value: io.k8s.api.core.v1.ResourceQuotaStatus) : ResourceQuota = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.ResourceQuotaSpec) : ResourceQuota = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceQuota = copy(metadata = Some(value))
}

