package io.k8s.api.core.v1


/** ResourceFieldSelector represents container resources (cpu, memory) and their output format */
final case class ResourceFieldSelector(
  containerName : Option[String] = None,
  divisor : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None,
  resource : String
) {
  def withContainerName(value: String) : ResourceFieldSelector = copy(containerName = Some(value))
  def withDivisor(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : ResourceFieldSelector = copy(divisor = Some(value))
  def withResource(value: String) : ResourceFieldSelector = copy(resource = value)
}

