package io.k8s.api.core.v1


/** ReplicationControllerSpec is the specification of a replication controller. */
final case class ReplicationControllerSpec(
  minReadySeconds : Option[Int] = None,
  replicas : Option[Int] = None,
  selector : Option[Map[String, String]] = None,
  template : Option[io.k8s.api.core.v1.PodTemplateSpec] = None
) {
  def withMinReadySeconds(value: Int) : ReplicationControllerSpec = copy(minReadySeconds = Some(value))
  def withReplicas(value: Int) : ReplicationControllerSpec = copy(replicas = Some(value))
  def withSelector(value: Map[String, String]) : ReplicationControllerSpec = copy(selector = Some(value))
  def addSelector(newValues: (String, String)*) : ReplicationControllerSpec = copy(selector = Some(selector.fold(newValues.toMap)(_ ++ newValues)))

  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : ReplicationControllerSpec = copy(template = Some(value))
}

