package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ReplicationControllerList is a collection of replication controllers. */
final case class ReplicationControllerList(
  items : Seq[io.k8s.api.core.v1.ReplicationController],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ReplicationControllerList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.ReplicationController]) : ReplicationControllerList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.ReplicationController*) : ReplicationControllerList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ReplicationControllerList = copy(metadata = Some(value))
}

