package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ReplicationController represents the configuration of a replication controller. */
final case class ReplicationController(
  status : Option[io.k8s.api.core.v1.ReplicationControllerStatus] = None,
  spec : Option[io.k8s.api.core.v1.ReplicationControllerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ReplicationController", "v1")

  def withStatus(value: io.k8s.api.core.v1.ReplicationControllerStatus) : ReplicationController = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.ReplicationControllerSpec) : ReplicationController = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicationController = copy(metadata = Some(value))
}

