package io.k8s.api.core.v1


/** Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling. */
final case class RBDVolumeSource(
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  image : String,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  pool : Option[String] = None,
  keyring : Option[String] = None,
  monitors : Seq[String],
  user : Option[String] = None
) {
  def withReadOnly(value: Boolean) : RBDVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : RBDVolumeSource = copy(fsType = Some(value))
  def withImage(value: String) : RBDVolumeSource = copy(image = value)
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : RBDVolumeSource = copy(secretRef = Some(value))
  def withPool(value: String) : RBDVolumeSource = copy(pool = Some(value))
  def withKeyring(value: String) : RBDVolumeSource = copy(keyring = Some(value))
  def withMonitors(value: Seq[String]) : RBDVolumeSource = copy(monitors = value)
  def addMonitors(newValues: String*) : RBDVolumeSource = copy(monitors = monitors ++ newValues)

  def withUser(value: String) : RBDVolumeSource = copy(user = Some(value))
}

