package io.k8s.api.core.v1


/** Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling. */
final case class RBDPersistentVolumeSource(
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  image : String,
  secretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  pool : Option[String] = None,
  keyring : Option[String] = None,
  monitors : Seq[String],
  user : Option[String] = None
) {
  def withReadOnly(value: Boolean) : RBDPersistentVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : RBDPersistentVolumeSource = copy(fsType = Some(value))
  def withImage(value: String) : RBDPersistentVolumeSource = copy(image = value)
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : RBDPersistentVolumeSource = copy(secretRef = Some(value))
  def withPool(value: String) : RBDPersistentVolumeSource = copy(pool = Some(value))
  def withKeyring(value: String) : RBDPersistentVolumeSource = copy(keyring = Some(value))
  def withMonitors(value: Seq[String]) : RBDPersistentVolumeSource = copy(monitors = value)
  def addMonitors(newValues: String*) : RBDPersistentVolumeSource = copy(monitors = monitors ++ newValues)

  def withUser(value: String) : RBDPersistentVolumeSource = copy(user = Some(value))
}

