package io.k8s.api.core.v1


/** Represents a projected volume source */
final case class ProjectedVolumeSource(
  defaultMode : Option[Int] = None,
  sources : Option[Seq[io.k8s.api.core.v1.VolumeProjection]] = None
) {
  def withDefaultMode(value: Int) : ProjectedVolumeSource = copy(defaultMode = Some(value))
  def withSources(value: Seq[io.k8s.api.core.v1.VolumeProjection]) : ProjectedVolumeSource = copy(sources = Some(value))
  def addSources(newValues: io.k8s.api.core.v1.VolumeProjection*) : ProjectedVolumeSource = copy(sources = Some(sources.fold(newValues)(_ ++ newValues)))

}

