package io.k8s.api.core.v1


/** Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic. */
final case class Probe(
  timeoutSeconds : Option[Int] = None,
  grpc : Option[io.k8s.api.core.v1.GRPCAction] = None,
  tcpSocket : Option[io.k8s.api.core.v1.TCPSocketAction] = None,
  initialDelaySeconds : Option[Int] = None,
  failureThreshold : Option[Int] = None,
  httpGet : Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  terminationGracePeriodSeconds : Option[Int] = None,
  exec : Option[io.k8s.api.core.v1.ExecAction] = None,
  periodSeconds : Option[Int] = None,
  successThreshold : Option[Int] = None
) {
  def withTimeoutSeconds(value: Int) : Probe = copy(timeoutSeconds = Some(value))
  def withGrpc(value: io.k8s.api.core.v1.GRPCAction) : Probe = copy(grpc = Some(value))
  def withTcpSocket(value: io.k8s.api.core.v1.TCPSocketAction) : Probe = copy(tcpSocket = Some(value))
  def withInitialDelaySeconds(value: Int) : Probe = copy(initialDelaySeconds = Some(value))
  def withFailureThreshold(value: Int) : Probe = copy(failureThreshold = Some(value))
  def withHttpGet(value: io.k8s.api.core.v1.HTTPGetAction) : Probe = copy(httpGet = Some(value))
  def withTerminationGracePeriodSeconds(value: Int) : Probe = copy(terminationGracePeriodSeconds = Some(value))
  def withExec(value: io.k8s.api.core.v1.ExecAction) : Probe = copy(exec = Some(value))
  def withPeriodSeconds(value: Int) : Probe = copy(periodSeconds = Some(value))
  def withSuccessThreshold(value: Int) : Probe = copy(successThreshold = Some(value))
}

