package io.k8s.api.core.v1


/** An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op). */
final case class PreferredSchedulingTerm(
  preference : io.k8s.api.core.v1.NodeSelectorTerm,
  weight : Int
) {
  def withPreference(value: io.k8s.api.core.v1.NodeSelectorTerm) : PreferredSchedulingTerm = copy(preference = value)
  def withWeight(value: Int) : PreferredSchedulingTerm = copy(weight = value)
}

