package io.k8s.api.core.v1


/** PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane. */
final case class PodStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.PodCondition]] = None,
  qosClass : Option[String] = None,
  startTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  phase : Option[String] = None,
  reason : Option[String] = None,
  ephemeralContainerStatuses : Option[Seq[io.k8s.api.core.v1.ContainerStatus]] = None,
  hostIP : Option[String] = None,
  message : Option[String] = None,
  containerStatuses : Option[Seq[io.k8s.api.core.v1.ContainerStatus]] = None,
  podIP : Option[String] = None,
  nominatedNodeName : Option[String] = None,
  podIPs : Option[Seq[io.k8s.api.core.v1.PodIP]] = None,
  initContainerStatuses : Option[Seq[io.k8s.api.core.v1.ContainerStatus]] = None
) {
  def withConditions(value: Seq[io.k8s.api.core.v1.PodCondition]) : PodStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.core.v1.PodCondition*) : PodStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withQosClass(value: String) : PodStatus = copy(qosClass = Some(value))
  def withStartTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodStatus = copy(startTime = Some(value))
  def withPhase(value: String) : PodStatus = copy(phase = Some(value))
  def withReason(value: String) : PodStatus = copy(reason = Some(value))
  def withEphemeralContainerStatuses(value: Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(ephemeralContainerStatuses = Some(value))
  def addEphemeralContainerStatuses(newValues: io.k8s.api.core.v1.ContainerStatus*) : PodStatus = copy(ephemeralContainerStatuses = Some(ephemeralContainerStatuses.fold(newValues)(_ ++ newValues)))

  def withHostIP(value: String) : PodStatus = copy(hostIP = Some(value))
  def withMessage(value: String) : PodStatus = copy(message = Some(value))
  def withContainerStatuses(value: Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(containerStatuses = Some(value))
  def addContainerStatuses(newValues: io.k8s.api.core.v1.ContainerStatus*) : PodStatus = copy(containerStatuses = Some(containerStatuses.fold(newValues)(_ ++ newValues)))

  def withPodIP(value: String) : PodStatus = copy(podIP = Some(value))
  def withNominatedNodeName(value: String) : PodStatus = copy(nominatedNodeName = Some(value))
  def withPodIPs(value: Seq[io.k8s.api.core.v1.PodIP]) : PodStatus = copy(podIPs = Some(value))
  def addPodIPs(newValues: io.k8s.api.core.v1.PodIP*) : PodStatus = copy(podIPs = Some(podIPs.fold(newValues)(_ ++ newValues)))

  def withInitContainerStatuses(value: Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(initContainerStatuses = Some(value))
  def addInitContainerStatuses(newValues: io.k8s.api.core.v1.ContainerStatus*) : PodStatus = copy(initContainerStatuses = Some(initContainerStatuses.fold(newValues)(_ ++ newValues)))

}

