package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PodList is a list of Pods. */
final case class PodList(
  items : Seq[io.k8s.api.core.v1.Pod],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PodList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Pod]) : PodList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Pod*) : PodList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodList = copy(metadata = Some(value))
}

