package io.k8s.api.core.v1


/** PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy. */
final case class PodDNSConfig(
  nameservers : Option[Seq[String]] = None,
  options : Option[Seq[io.k8s.api.core.v1.PodDNSConfigOption]] = None,
  searches : Option[Seq[String]] = None
) {
  def withNameservers(value: Seq[String]) : PodDNSConfig = copy(nameservers = Some(value))
  def addNameservers(newValues: String*) : PodDNSConfig = copy(nameservers = Some(nameservers.fold(newValues)(_ ++ newValues)))

  def withOptions(value: Seq[io.k8s.api.core.v1.PodDNSConfigOption]) : PodDNSConfig = copy(options = Some(value))
  def addOptions(newValues: io.k8s.api.core.v1.PodDNSConfigOption*) : PodDNSConfig = copy(options = Some(options.fold(newValues)(_ ++ newValues)))

  def withSearches(value: Seq[String]) : PodDNSConfig = copy(searches = Some(value))
  def addSearches(newValues: String*) : PodDNSConfig = copy(searches = Some(searches.fold(newValues)(_ ++ newValues)))

}

