package io.k8s.api.core.v1


/** PodCondition contains details for the current condition of this pod. */
final case class PodCondition(
  lastProbeTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withLastProbeTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodCondition = copy(lastProbeTime = Some(value))
  def withReason(value: String) : PodCondition = copy(reason = Some(value))
  def withStatus(value: String) : PodCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : PodCondition = copy(message = Some(value))
  def withType(value: String) : PodCondition = copy(`type` = value)
}

