package io.k8s.api.core.v1


/** Pod anti affinity is a group of inter pod anti affinity scheduling rules. */
final case class PodAntiAffinity(
  preferredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]] = None,
  requiredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.PodAffinityTerm]] = None
) {
  def withPreferredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]) : PodAntiAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(value))
  def addPreferredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.WeightedPodAffinityTerm*) : PodAntiAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(preferredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))

  def withRequiredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.PodAffinityTerm]) : PodAntiAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(value))
  def addRequiredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.PodAffinityTerm*) : PodAntiAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(requiredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))

}

