package io.k8s.api.core.v1


/** PersistentVolumeStatus is the current status of a persistent volume. */
final case class PersistentVolumeStatus(
  message : Option[String] = None,
  phase : Option[String] = None,
  reason : Option[String] = None
) {
  def withMessage(value: String) : PersistentVolumeStatus = copy(message = Some(value))
  def withPhase(value: String) : PersistentVolumeStatus = copy(phase = Some(value))
  def withReason(value: String) : PersistentVolumeStatus = copy(reason = Some(value))
}

