package io.k8s.api.core.v1


/** PersistentVolumeSpec is the specification of a persistent volume. */
final case class PersistentVolumeSpec(
  scaleIO : Option[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] = None,
  csi : Option[io.k8s.api.core.v1.CSIPersistentVolumeSource] = None,
  accessModes : Option[Seq[String]] = None,
  mountOptions : Option[Seq[String]] = None,
  nodeAffinity : Option[io.k8s.api.core.v1.VolumeNodeAffinity] = None,
  azureDisk : Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  azureFile : Option[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] = None,
  hostPath : Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  rbd : Option[io.k8s.api.core.v1.RBDPersistentVolumeSource] = None,
  portworxVolume : Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  persistentVolumeReclaimPolicy : Option[String] = None,
  glusterfs : Option[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] = None,
  volumeMode : Option[String] = None,
  flocker : Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  claimRef : Option[io.k8s.api.core.v1.ObjectReference] = None,
  fc : Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  local : Option[io.k8s.api.core.v1.LocalVolumeSource] = None,
  storageClassName : Option[String] = None,
  photonPersistentDisk : Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  gcePersistentDisk : Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  vsphereVolume : Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None,
  iscsi : Option[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] = None,
  cinder : Option[io.k8s.api.core.v1.CinderPersistentVolumeSource] = None,
  cephfs : Option[io.k8s.api.core.v1.CephFSPersistentVolumeSource] = None,
  awsElasticBlockStore : Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  flexVolume : Option[io.k8s.api.core.v1.FlexPersistentVolumeSource] = None,
  nfs : Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  quobyte : Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  storageos : Option[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] = None,
  capacity : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {
  def withScaleIO(value: io.k8s.api.core.v1.ScaleIOPersistentVolumeSource) : PersistentVolumeSpec = copy(scaleIO = Some(value))
  def withCsi(value: io.k8s.api.core.v1.CSIPersistentVolumeSource) : PersistentVolumeSpec = copy(csi = Some(value))
  def withAccessModes(value: Seq[String]) : PersistentVolumeSpec = copy(accessModes = Some(value))
  def addAccessModes(newValues: String*) : PersistentVolumeSpec = copy(accessModes = Some(accessModes.fold(newValues)(_ ++ newValues)))

  def withMountOptions(value: Seq[String]) : PersistentVolumeSpec = copy(mountOptions = Some(value))
  def addMountOptions(newValues: String*) : PersistentVolumeSpec = copy(mountOptions = Some(mountOptions.fold(newValues)(_ ++ newValues)))

  def withNodeAffinity(value: io.k8s.api.core.v1.VolumeNodeAffinity) : PersistentVolumeSpec = copy(nodeAffinity = Some(value))
  def withAzureDisk(value: io.k8s.api.core.v1.AzureDiskVolumeSource) : PersistentVolumeSpec = copy(azureDisk = Some(value))
  def withAzureFile(value: io.k8s.api.core.v1.AzureFilePersistentVolumeSource) : PersistentVolumeSpec = copy(azureFile = Some(value))
  def withHostPath(value: io.k8s.api.core.v1.HostPathVolumeSource) : PersistentVolumeSpec = copy(hostPath = Some(value))
  def withRbd(value: io.k8s.api.core.v1.RBDPersistentVolumeSource) : PersistentVolumeSpec = copy(rbd = Some(value))
  def withPortworxVolume(value: io.k8s.api.core.v1.PortworxVolumeSource) : PersistentVolumeSpec = copy(portworxVolume = Some(value))
  def withPersistentVolumeReclaimPolicy(value: String) : PersistentVolumeSpec = copy(persistentVolumeReclaimPolicy = Some(value))
  def withGlusterfs(value: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource) : PersistentVolumeSpec = copy(glusterfs = Some(value))
  def withVolumeMode(value: String) : PersistentVolumeSpec = copy(volumeMode = Some(value))
  def withFlocker(value: io.k8s.api.core.v1.FlockerVolumeSource) : PersistentVolumeSpec = copy(flocker = Some(value))
  def withClaimRef(value: io.k8s.api.core.v1.ObjectReference) : PersistentVolumeSpec = copy(claimRef = Some(value))
  def withFc(value: io.k8s.api.core.v1.FCVolumeSource) : PersistentVolumeSpec = copy(fc = Some(value))
  def withLocal(value: io.k8s.api.core.v1.LocalVolumeSource) : PersistentVolumeSpec = copy(local = Some(value))
  def withStorageClassName(value: String) : PersistentVolumeSpec = copy(storageClassName = Some(value))
  def withPhotonPersistentDisk(value: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : PersistentVolumeSpec = copy(photonPersistentDisk = Some(value))
  def withGcePersistentDisk(value: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource) : PersistentVolumeSpec = copy(gcePersistentDisk = Some(value))
  def withVsphereVolume(value: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : PersistentVolumeSpec = copy(vsphereVolume = Some(value))
  def withIscsi(value: io.k8s.api.core.v1.ISCSIPersistentVolumeSource) : PersistentVolumeSpec = copy(iscsi = Some(value))
  def withCinder(value: io.k8s.api.core.v1.CinderPersistentVolumeSource) : PersistentVolumeSpec = copy(cinder = Some(value))
  def withCephfs(value: io.k8s.api.core.v1.CephFSPersistentVolumeSource) : PersistentVolumeSpec = copy(cephfs = Some(value))
  def withAwsElasticBlockStore(value: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource) : PersistentVolumeSpec = copy(awsElasticBlockStore = Some(value))
  def withFlexVolume(value: io.k8s.api.core.v1.FlexPersistentVolumeSource) : PersistentVolumeSpec = copy(flexVolume = Some(value))
  def withNfs(value: io.k8s.api.core.v1.NFSVolumeSource) : PersistentVolumeSpec = copy(nfs = Some(value))
  def withQuobyte(value: io.k8s.api.core.v1.QuobyteVolumeSource) : PersistentVolumeSpec = copy(quobyte = Some(value))
  def withStorageos(value: io.k8s.api.core.v1.StorageOSPersistentVolumeSource) : PersistentVolumeSpec = copy(storageos = Some(value))
  def withCapacity(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeSpec = copy(capacity = Some(value))
  def addCapacity(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PersistentVolumeSpec = copy(capacity = Some(capacity.fold(newValues.toMap)(_ ++ newValues)))

}

