package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PersistentVolumeList is a list of PersistentVolume items. */
final case class PersistentVolumeList(
  items : Seq[io.k8s.api.core.v1.PersistentVolume],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.PersistentVolume]) : PersistentVolumeList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.PersistentVolume*) : PersistentVolumeList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PersistentVolumeList = copy(metadata = Some(value))
}

