package io.k8s.api.core.v1


/** PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system). */
final case class PersistentVolumeClaimVolumeSource(
  claimName : String,
  readOnly : Option[Boolean] = None
) {
  def withClaimName(value: String) : PersistentVolumeClaimVolumeSource = copy(claimName = value)
  def withReadOnly(value: Boolean) : PersistentVolumeClaimVolumeSource = copy(readOnly = Some(value))
}

