package io.k8s.api.core.v1


/** PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource. */
final case class PersistentVolumeClaimTemplate(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : io.k8s.api.core.v1.PersistentVolumeClaimSpec
) {
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaimTemplate = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaimTemplate = copy(spec = value)
}

