package io.k8s.api.core.v1


/** PersistentVolumeClaimStatus is the current status of a persistent volume claim. */
final case class PersistentVolumeClaimStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]] = None,
  accessModes : Option[Seq[String]] = None,
  phase : Option[String] = None,
  resizeStatus : Option[String] = None,
  allocatedResources : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  capacity : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {
  def withConditions(value: Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]) : PersistentVolumeClaimStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.core.v1.PersistentVolumeClaimCondition*) : PersistentVolumeClaimStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withAccessModes(value: Seq[String]) : PersistentVolumeClaimStatus = copy(accessModes = Some(value))
  def addAccessModes(newValues: String*) : PersistentVolumeClaimStatus = copy(accessModes = Some(accessModes.fold(newValues)(_ ++ newValues)))

  def withPhase(value: String) : PersistentVolumeClaimStatus = copy(phase = Some(value))
  def withResizeStatus(value: String) : PersistentVolumeClaimStatus = copy(resizeStatus = Some(value))
  def withAllocatedResources(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeClaimStatus = copy(allocatedResources = Some(value))
  def addAllocatedResources(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PersistentVolumeClaimStatus = copy(allocatedResources = Some(allocatedResources.fold(newValues.toMap)(_ ++ newValues)))

  def withCapacity(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeClaimStatus = copy(capacity = Some(value))
  def addCapacity(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PersistentVolumeClaimStatus = copy(capacity = Some(capacity.fold(newValues.toMap)(_ ++ newValues)))

}

