package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PersistentVolumeClaimList is a list of PersistentVolumeClaim items. */
final case class PersistentVolumeClaimList(
  items : Seq[io.k8s.api.core.v1.PersistentVolumeClaim],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeClaimList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.PersistentVolumeClaim]) : PersistentVolumeClaimList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.PersistentVolumeClaim*) : PersistentVolumeClaimList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PersistentVolumeClaimList = copy(metadata = Some(value))
}

