package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes */
final case class PersistentVolume(
  status : Option[io.k8s.api.core.v1.PersistentVolumeStatus] = None,
  spec : Option[io.k8s.api.core.v1.PersistentVolumeSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolume", "v1")

  def withStatus(value: io.k8s.api.core.v1.PersistentVolumeStatus) : PersistentVolume = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeSpec) : PersistentVolume = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolume = copy(metadata = Some(value))
}

