package io.k8s.api.core.v1


/** NodeStatus is information about the current status of a node. */
final case class NodeStatus(
  volumesInUse : Option[Seq[String]] = None,
  conditions : Option[Seq[io.k8s.api.core.v1.NodeCondition]] = None,
  nodeInfo : Option[io.k8s.api.core.v1.NodeSystemInfo] = None,
  volumesAttached : Option[Seq[io.k8s.api.core.v1.AttachedVolume]] = None,
  phase : Option[String] = None,
  config : Option[io.k8s.api.core.v1.NodeConfigStatus] = None,
  allocatable : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  images : Option[Seq[io.k8s.api.core.v1.ContainerImage]] = None,
  daemonEndpoints : Option[io.k8s.api.core.v1.NodeDaemonEndpoints] = None,
  addresses : Option[Seq[io.k8s.api.core.v1.NodeAddress]] = None,
  capacity : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {
  def withVolumesInUse(value: Seq[String]) : NodeStatus = copy(volumesInUse = Some(value))
  def addVolumesInUse(newValues: String*) : NodeStatus = copy(volumesInUse = Some(volumesInUse.fold(newValues)(_ ++ newValues)))

  def withConditions(value: Seq[io.k8s.api.core.v1.NodeCondition]) : NodeStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.core.v1.NodeCondition*) : NodeStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withNodeInfo(value: io.k8s.api.core.v1.NodeSystemInfo) : NodeStatus = copy(nodeInfo = Some(value))
  def withVolumesAttached(value: Seq[io.k8s.api.core.v1.AttachedVolume]) : NodeStatus = copy(volumesAttached = Some(value))
  def addVolumesAttached(newValues: io.k8s.api.core.v1.AttachedVolume*) : NodeStatus = copy(volumesAttached = Some(volumesAttached.fold(newValues)(_ ++ newValues)))

  def withPhase(value: String) : NodeStatus = copy(phase = Some(value))
  def withConfig(value: io.k8s.api.core.v1.NodeConfigStatus) : NodeStatus = copy(config = Some(value))
  def withAllocatable(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : NodeStatus = copy(allocatable = Some(value))
  def addAllocatable(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : NodeStatus = copy(allocatable = Some(allocatable.fold(newValues.toMap)(_ ++ newValues)))

  def withImages(value: Seq[io.k8s.api.core.v1.ContainerImage]) : NodeStatus = copy(images = Some(value))
  def addImages(newValues: io.k8s.api.core.v1.ContainerImage*) : NodeStatus = copy(images = Some(images.fold(newValues)(_ ++ newValues)))

  def withDaemonEndpoints(value: io.k8s.api.core.v1.NodeDaemonEndpoints) : NodeStatus = copy(daemonEndpoints = Some(value))
  def withAddresses(value: Seq[io.k8s.api.core.v1.NodeAddress]) : NodeStatus = copy(addresses = Some(value))
  def addAddresses(newValues: io.k8s.api.core.v1.NodeAddress*) : NodeStatus = copy(addresses = Some(addresses.fold(newValues)(_ ++ newValues)))

  def withCapacity(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : NodeStatus = copy(capacity = Some(value))
  def addCapacity(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : NodeStatus = copy(capacity = Some(capacity.fold(newValues.toMap)(_ ++ newValues)))

}

