package io.k8s.api.core.v1


/** NodeSpec describes the attributes that a node is created with. */
final case class NodeSpec(
  externalID : Option[String] = None,
  taints : Option[Seq[io.k8s.api.core.v1.Taint]] = None,
  configSource : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  unschedulable : Option[Boolean] = None,
  podCIDR : Option[String] = None,
  providerID : Option[String] = None,
  podCIDRs : Option[Seq[String]] = None
) {
  def withExternalID(value: String) : NodeSpec = copy(externalID = Some(value))
  def withTaints(value: Seq[io.k8s.api.core.v1.Taint]) : NodeSpec = copy(taints = Some(value))
  def addTaints(newValues: io.k8s.api.core.v1.Taint*) : NodeSpec = copy(taints = Some(taints.fold(newValues)(_ ++ newValues)))

  def withConfigSource(value: io.k8s.api.core.v1.NodeConfigSource) : NodeSpec = copy(configSource = Some(value))
  def withUnschedulable(value: Boolean) : NodeSpec = copy(unschedulable = Some(value))
  def withPodCIDR(value: String) : NodeSpec = copy(podCIDR = Some(value))
  def withProviderID(value: String) : NodeSpec = copy(providerID = Some(value))
  def withPodCIDRs(value: Seq[String]) : NodeSpec = copy(podCIDRs = Some(value))
  def addPodCIDRs(newValues: String*) : NodeSpec = copy(podCIDRs = Some(podCIDRs.fold(newValues)(_ ++ newValues)))

}

