package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** NodeList is the whole list of all Nodes which have been registered with master. */
final case class NodeList(
  items : Seq[io.k8s.api.core.v1.Node],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "NodeList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Node]) : NodeList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Node*) : NodeList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NodeList = copy(metadata = Some(value))
}

