package io.k8s.api.core.v1


/** Node affinity is a group of node affinity scheduling rules. */
final case class NodeAffinity(
  preferredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.PreferredSchedulingTerm]] = None,
  requiredDuringSchedulingIgnoredDuringExecution : Option[io.k8s.api.core.v1.NodeSelector] = None
) {
  def withPreferredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.PreferredSchedulingTerm]) : NodeAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(value))
  def addPreferredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.PreferredSchedulingTerm*) : NodeAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(preferredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))

  def withRequiredDuringSchedulingIgnoredDuringExecution(value: io.k8s.api.core.v1.NodeSelector) : NodeAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(value))
}

