package io.k8s.api.core.v1


/** NamespaceStatus is information about the current status of a Namespace. */
final case class NamespaceStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.NamespaceCondition]] = None,
  phase : Option[String] = None
) {
  def withConditions(value: Seq[io.k8s.api.core.v1.NamespaceCondition]) : NamespaceStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.core.v1.NamespaceCondition*) : NamespaceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withPhase(value: String) : NamespaceStatus = copy(phase = Some(value))
}

