package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Namespace provides a scope for Names. Use of multiple namespaces is optional. */
final case class Namespace(
  status : Option[io.k8s.api.core.v1.NamespaceStatus] = None,
  spec : Option[io.k8s.api.core.v1.NamespaceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Namespace", "v1")

  def withStatus(value: io.k8s.api.core.v1.NamespaceStatus) : Namespace = copy(status = Some(value))
  def withSpec(value: io.k8s.api.core.v1.NamespaceSpec) : Namespace = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Namespace = copy(metadata = Some(value))
}

