package io.k8s.api.core.v1


/** Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling. */
final case class NFSVolumeSource(
  path : String,
  readOnly : Option[Boolean] = None,
  server : String
) {
  def withPath(value: String) : NFSVolumeSource = copy(path = value)
  def withReadOnly(value: Boolean) : NFSVolumeSource = copy(readOnly = Some(value))
  def withServer(value: String) : NFSVolumeSource = copy(server = value)
}

