package io.k8s.api.core.v1


/** LoadBalancerStatus represents the status of a load-balancer. */
final case class LoadBalancerStatus(
  ingress : Option[Seq[io.k8s.api.core.v1.LoadBalancerIngress]] = None
) {
  def withIngress(value: Seq[io.k8s.api.core.v1.LoadBalancerIngress]) : LoadBalancerStatus = copy(ingress = Some(value))
  def addIngress(newValues: io.k8s.api.core.v1.LoadBalancerIngress*) : LoadBalancerStatus = copy(ingress = Some(ingress.fold(newValues)(_ ++ newValues)))

}

