package io.k8s.api.core.v1


/** Maps a string key to a path within a volume. */
final case class KeyToPath(
  key : String,
  mode : Option[Int] = None,
  path : String
) {
  def withKey(value: String) : KeyToPath = copy(key = value)
  def withMode(value: Int) : KeyToPath = copy(mode = Some(value))
  def withPath(value: String) : KeyToPath = copy(path = value)
}

