package io.k8s.api.core.v1


/** ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling. */
final case class ISCSIPersistentVolumeSource(
  portals : Option[Seq[String]] = None,
  readOnly : Option[Boolean] = None,
  chapAuthDiscovery : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  iqn : String,
  initiatorName : Option[String] = None,
  iscsiInterface : Option[String] = None,
  targetPortal : String,
  lun : Int,
  chapAuthSession : Option[Boolean] = None
) {
  def withPortals(value: Seq[String]) : ISCSIPersistentVolumeSource = copy(portals = Some(value))
  def addPortals(newValues: String*) : ISCSIPersistentVolumeSource = copy(portals = Some(portals.fold(newValues)(_ ++ newValues)))

  def withReadOnly(value: Boolean) : ISCSIPersistentVolumeSource = copy(readOnly = Some(value))
  def withChapAuthDiscovery(value: Boolean) : ISCSIPersistentVolumeSource = copy(chapAuthDiscovery = Some(value))
  def withFsType(value: String) : ISCSIPersistentVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : ISCSIPersistentVolumeSource = copy(secretRef = Some(value))
  def withIqn(value: String) : ISCSIPersistentVolumeSource = copy(iqn = value)
  def withInitiatorName(value: String) : ISCSIPersistentVolumeSource = copy(initiatorName = Some(value))
  def withIscsiInterface(value: String) : ISCSIPersistentVolumeSource = copy(iscsiInterface = Some(value))
  def withTargetPortal(value: String) : ISCSIPersistentVolumeSource = copy(targetPortal = value)
  def withLun(value: Int) : ISCSIPersistentVolumeSource = copy(lun = value)
  def withChapAuthSession(value: Boolean) : ISCSIPersistentVolumeSource = copy(chapAuthSession = Some(value))
}

