package io.k8s.api.core.v1


/** Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling. */
final case class HostPathVolumeSource(
  path : String,
  `type` : Option[String] = None
) {
  def withPath(value: String) : HostPathVolumeSource = copy(path = value)
  def withType(value: String) : HostPathVolumeSource = copy(`type` = Some(value))
}

