package io.k8s.api.core.v1


/** HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. */
final case class HostAlias(
  hostnames : Option[Seq[String]] = None,
  ip : Option[String] = None
) {
  def withHostnames(value: Seq[String]) : HostAlias = copy(hostnames = Some(value))
  def addHostnames(newValues: String*) : HostAlias = copy(hostnames = Some(hostnames.fold(newValues)(_ ++ newValues)))

  def withIp(value: String) : HostAlias = copy(ip = Some(value))
}

