package io.k8s.api.core.v1


/** Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling. */
final case class GlusterfsVolumeSource(
  endpoints : String,
  path : String,
  readOnly : Option[Boolean] = None
) {
  def withEndpoints(value: String) : GlusterfsVolumeSource = copy(endpoints = value)
  def withPath(value: String) : GlusterfsVolumeSource = copy(path = value)
  def withReadOnly(value: Boolean) : GlusterfsVolumeSource = copy(readOnly = Some(value))
}

