package io.k8s.api.core.v1


/** Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling. */
final case class FlockerVolumeSource(
  datasetName : Option[String] = None,
  datasetUUID : Option[String] = None
) {
  def withDatasetName(value: String) : FlockerVolumeSource = copy(datasetName = Some(value))
  def withDatasetUUID(value: String) : FlockerVolumeSource = copy(datasetUUID = Some(value))
}

