package io.k8s.api.core.v1


/** FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. */
final case class FlexVolumeSource(
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  options : Option[Map[String, String]] = None,
  driver : String
) {
  def withReadOnly(value: Boolean) : FlexVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : FlexVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : FlexVolumeSource = copy(secretRef = Some(value))
  def withOptions(value: Map[String, String]) : FlexVolumeSource = copy(options = Some(value))
  def addOptions(newValues: (String, String)*) : FlexVolumeSource = copy(options = Some(options.fold(newValues.toMap)(_ ++ newValues)))

  def withDriver(value: String) : FlexVolumeSource = copy(driver = value)
}

