package io.k8s.api.core.v1


/** FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin. */
final case class FlexPersistentVolumeSource(
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  options : Option[Map[String, String]] = None,
  driver : String
) {
  def withReadOnly(value: Boolean) : FlexPersistentVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : FlexPersistentVolumeSource = copy(fsType = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : FlexPersistentVolumeSource = copy(secretRef = Some(value))
  def withOptions(value: Map[String, String]) : FlexPersistentVolumeSource = copy(options = Some(value))
  def addOptions(newValues: (String, String)*) : FlexPersistentVolumeSource = copy(options = Some(options.fold(newValues.toMap)(_ ++ newValues)))

  def withDriver(value: String) : FlexPersistentVolumeSource = copy(driver = value)
}

