package io.k8s.api.core.v1


/** Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling. */
final case class FCVolumeSource(
  targetWWNs : Option[Seq[String]] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  wwids : Option[Seq[String]] = None,
  lun : Option[Int] = None
) {
  def withTargetWWNs(value: Seq[String]) : FCVolumeSource = copy(targetWWNs = Some(value))
  def addTargetWWNs(newValues: String*) : FCVolumeSource = copy(targetWWNs = Some(targetWWNs.fold(newValues)(_ ++ newValues)))

  def withReadOnly(value: Boolean) : FCVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : FCVolumeSource = copy(fsType = Some(value))
  def withWwids(value: Seq[String]) : FCVolumeSource = copy(wwids = Some(value))
  def addWwids(newValues: String*) : FCVolumeSource = copy(wwids = Some(wwids.fold(newValues)(_ ++ newValues)))

  def withLun(value: Int) : FCVolumeSource = copy(lun = Some(value))
}

