package io.k8s.api.core.v1


/** ExecAction describes a "run in container" action. */
final case class ExecAction(
  command : Option[Seq[String]] = None
) {
  def withCommand(value: Seq[String]) : ExecAction = copy(command = Some(value))
  def addCommand(newValues: String*) : ExecAction = copy(command = Some(command.fold(newValues)(_ ++ newValues)))

}

